/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.viewfinder;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.camera.infrastructure.SynchronizedCameraInHandActions;
import io.github.mortuusars.exposure.camera.infrastructure.ZoomDirection;
import io.github.mortuusars.exposure.camera.viewfinder.SelfieClient;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderOverlay;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.CameraInHand;
import io.github.mortuusars.exposure.util.Fov;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ViewfinderClient {
    public static final float ZOOM_STEP = 8.0f;
    public static final float ZOOM_PRECISE_MODIFIER = 0.25f;
    private static boolean isOpen;
    private static FocalRange focalRange;
    private static double targetFov;
    private static double currentFov;
    private static boolean shouldRestoreFov;
    @Nullable
    private static String previousShaderEffect;

    public static boolean isOpen() {
        return isOpen;
    }

    public static boolean isLookingThrough() {
        return ViewfinderClient.isOpen() && (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON || Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_FRONT);
    }

    public static void open() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Player should not be null");
        Preconditions.checkState((boolean)player.m_9236_().m_5776_(), (Object)"This should be called only client-side.");
        if (ViewfinderClient.isOpen()) {
            return;
        }
        @Nullable InteractionHand activeHand = CameraInHand.getActiveHand((Player)player);
        Preconditions.checkState((activeHand != null ? 1 : 0) != 0, (Object)"Player should have active camera in hand.");
        ItemAndStack<CameraItem> camera = new ItemAndStack<CameraItem>(player.m_21120_(activeHand));
        focalRange = ((CameraItem)((Object)camera.getItem())).getFocalRange(camera.getStack());
        targetFov = Fov.focalLengthToFov(Mth.m_14036_((float)((CameraItem)((Object)camera.getItem())).getFocalLength(camera.getStack()), (float)focalRange.min(), (float)focalRange.max()));
        isOpen = true;
        Optional<ItemStack> attachment = ((CameraItem)((Object)camera.getItem())).getAttachment(camera.getStack(), CameraItem.FILTER_ATTACHMENT);
        attachment.ifPresent(stack -> {
            PostChain effect = Minecraft.m_91087_().f_91063_.m_109149_();
            if (effect != null) {
                previousShaderEffect = effect.m_110022_();
            }
            String itemName = Registry.f_122827_.m_7981_((Object)stack.m_41720_()).m_135815_();
            Minecraft.m_91087_().f_91063_.m_109128_(Exposure.resource("shaders/post/" + itemName + ".json"));
        });
        SelfieClient.update(camera, activeHand, false);
        ViewfinderOverlay.setup();
    }

    public static void close() {
        isOpen = false;
        targetFov = ((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
        Minecraft.m_91087_().f_91063_.m_109086_();
        if (previousShaderEffect != null) {
            Minecraft.m_91087_().f_91063_.m_109128_(new ResourceLocation(previousShaderEffect));
            previousShaderEffect = null;
        }
    }

    public static FocalRange getFocalRange() {
        return focalRange;
    }

    public static double getCurrentFov() {
        return currentFov;
    }

    public static float getSelfieCameraDistance() {
        return 1.75f;
    }

    public static void zoom(ZoomDirection direction, boolean precise) {
        double fov;
        double prevFov;
        double step = 8.0 * (1.0 - Mth.m_14008_((double)(((double)focalRange.min() - currentFov) / (double)focalRange.min()), (double)0.3f, (double)1.0));
        double inertia = Math.abs(targetFov - currentFov) * (double)0.8f;
        double change = step + inertia;
        if (precise) {
            change *= 0.25;
        }
        if (Math.abs((prevFov = targetFov) - (fov = Mth.m_14008_((double)(targetFov + (direction == ZoomDirection.IN ? -change : change)), (double)Fov.focalLengthToFov(focalRange.max()), (double)Fov.focalLengthToFov(focalRange.min())))) > (double)0.01f) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_216990_(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get());
        }
        targetFov = fov;
        SynchronizedCameraInHandActions.setZoom(Fov.fovToFocalLength(fov));
    }

    public static double modifyMouseSensitivity(double sensitivity) {
        if (!ViewfinderClient.isLookingThrough()) {
            return sensitivity;
        }
        double modifier = Mth.m_14008_((double)(1.0 - (Double)Config.Client.VIEWFINDER_ZOOM_SENSITIVITY_MODIFIER.get() * (((double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue() - currentFov) / 5.0)), (double)0.01, (double)2.0);
        return sensitivity * modifier;
    }

    public static void onPlayerTick(Player player) {
        if (!player.equals((Object)Minecraft.m_91087_().f_91074_)) {
            return;
        }
        boolean cameraActive = CameraInHand.isActive(player);
        if (cameraActive && !ViewfinderClient.isOpen()) {
            ViewfinderClient.open();
        } else if (!cameraActive && ViewfinderClient.isOpen()) {
            ViewfinderClient.close();
        }
    }

    public static boolean handleMouseScroll(ZoomDirection direction) {
        if (ViewfinderClient.isLookingThrough()) {
            ViewfinderClient.zoom(direction, false);
            return true;
        }
        return false;
    }

    public static double modifyFov(double fov) {
        if (ViewfinderClient.isLookingThrough()) {
            currentFov = Mth.m_14139_((double)Math.min(0.6f * Minecraft.m_91087_().m_91297_(), 0.6f), (double)currentFov, (double)targetFov);
            shouldRestoreFov = true;
            return currentFov;
        }
        if (shouldRestoreFov && Math.abs(currentFov - fov) > 1.0E-5) {
            currentFov = Mth.m_14139_((double)Math.min(0.8f * Minecraft.m_91087_().m_91297_(), 0.8f), (double)currentFov, (double)fov);
            return currentFov;
        }
        currentFov = fov;
        shouldRestoreFov = false;
        return fov;
    }

    static {
        focalRange = new FocalRange(18, 55);
        currentFov = targetFov = 90.0;
    }
}

